ORCA/M Asm65816 2.1.0

0001 C13E                       title 'Tool Locator--MessageCenter' 
0002 C13E              ****************************************************************
0003 C13E              *                                                              *
0004 C13E              *                      MessageCenter                           *
0005 C13E              *                                                              *
0006 C13E              ****************************************************************
0007 C13E
0008 C13E
0009 C13E              ****************************************************************
0010 C13E              *                                                              *
0011 C13E              *                   Copyright (C) 1985-1988,1991               *
0012 C13E              *                   All Rights Reserved                        *
0013 C13E              *                   Apple Computer, Inc.                       *
0014 C13E              *                                                              *
0015 C13E              ****************************************************************
0016 C13E
0017 C13E                       blanks off 
0018 C13E                       string asis 
0019 C13E
0020 C13E                       print push 
0021 C13E                       print off 
0022 C13E                       include 'all.macros' 
0023 C13E                       include '::sys.equs.asm' 
0024 C13E                       INCLUDE 'e16.memory' 
0025 C13E
0026 C13E                       include 'tl.equates.asm' 
0027 C13E                       print pop 
0028 C13E
0029 C13E
0030 C13E                       title ' Imported Addresses' 
0031 C13E              ;-----------------------------------------------
0032 C13E              ;
0033 C13E              ;   Imported addresses
0034 C13E              ;
0035 C13E              ;-----------------------------------------------
0036 C13E
0037 C13E                       IMPORT EndCall4 
0038 C13E                       IMPORT EndCall8 
0039 C13E                       IMPORT ErrOut4 
0040 C13E                       IMPORT ErrOut8 
0041 C13E                       IMPORT oBusyErr4 
0042 C13E                       IMPORT oEndCall0 
0043 C13E
0044 C13E                       eject 
0045 C13E              ****************************************************************
0046 C13E              *
0047 C13E              MessageCenter PROC EXPORT 
0048 C13E              *
0049 C13E              * Description
0050 C13E              *
0051 C13E              *
0052 C13E              ;   IN:    PUSH:WORD - Action:
0053 C13E              ;                                     1 = Add message.
0054 C13E              ;                                     2 = Get message.
0055 C13E              ;                                     3 = Delete message.
0056 C13E              ;          PUSH:WORD - Type.
0057 C13E              ;          PUSH:LONG - Handle.
0058 C13E              ;
0059 C13E              ;  OUT:    None.
0060 C13E              *
0061 C13E              * External Refs:
0062 C13E              *                   none
0063 C13E              *
0064 C13E              * Entry Points:
0065 C13E              *                   none
0066 C13E              *
0067 C13E                       longa on                       ; mode
0068 C13E                       longi on
0069 C13E              *
0070 C13E              ****************************************************************
0071 C13E
0072 C13E              ;
0073 C13E              ;
0074 C13E              ; --- Direct page and stack offsets ----------------------------------
0075 C13E              ;
0076 C13E              pointer  equ   0
0077 C13E              hand1    equ   pointer+4
0078 C13E              hand2    equ   hand1+4
0079 C13E              ;
0080 C13E              directPage equ   hand2+4
0081 C13E              longRet1 equ   directPage+2
0082 C13E              longRet2 equ   longRet1+3
0083 C13E              ;
0084 C13E              theHandle equ   longRet2+3
0085 C13E              theType  equ   theHandle+4
0086 C13E              theAction equ   theType+2
0087 C13E              endStack equ   theAction+2
0088 C13E              ;
0089 C13E              ;
0090 C13E              ; --- Message record offsets --------------------------------------------
0091 C13E              ;
0092 C13E              messNext equ   0                        Handle of next message.
0093 C13E              messType equ   messNext+4               Message type.
0094 C13E              messData equ   MessType+2               Message defined data.
0095 C13E              ;
0096 C13E              messageID equ   $9001                   Memory manager ID number.
0097 C13E
0098 C13E              ;
0099 C13E              ; --- Initialize direct page ------------------------------------------
0100 C13E              ;
0101 C13E 0B                    phd                            Save original direct page.
0102 C13F              ;
0103 C13F 3B                    tsc                            Make room on stack for local direct page.
0104 C140 38                    sec   
0105 C141 E9 0C 00              sbc   #directPage
0106 C144 1B                    tcs   
0107 C145              ;
0108 C145 1A                    inc   a                        (Direct offset is one more than stack.)
0109 C146 5B                    tcd                            Switch to direct page in stack.
0110 C147              ;
0111 C147              ;
0112 C147              ; --- Dispatch message task ------------------------------------------
0113 C147              ;
0114 C147 A5 1A                 lda   <theAction
0115 C149 3A                    dec   a
0116 C14A 0A                    asl   a
0117 C14B AA                    tax   
0118 C14C FC 6A C1              jsr   (messTasks,x)
0119 C14F AA                    tax                            Put error code in x.
0120 C150              ;
0121 C150              ;
0122 C150              ; --- Clean up stack and exit ----------------------------------------
0123 C150              ;
0124 C150 A5 0E                 lda   <longRet1                Move return addresses down over
0125 C152 85 16                 sta   <endStack-6              the parameters passed.
0126 C154 A5 10                 lda   <longRet1+2
0127 C156 85 18                 sta   <endStack-4
0128 C158 A5 12                 lda   <longRet1+4
0129 C15A 85 1A                 sta   <endStack-2
0130 C15C              ;
0131 C15C A5 0C                 lda   <directPage              Restore original direct page.
0132 C15E 5B                    tcd   
0133 C15F              ;
0134 C15F 3B                    tsc                            Free local stack space.
0135 C160 18                    clc   
0136 C161 69 16 00              adc   #endStack-6
0137 C164 1B                    tcs   
0138 C165              ;
0139 C165 8A                    txa                            Return error code in A.
0140 C166 C9 01 00              cmp   #1                       Set return error flag.
0141 C169 6B                    rtl   
0142 C16A              ;
0143 C16A              ;
0144 C16A              ;
0145 C16A 70 C1        messTasks DC W:addMessage
0146 C16C 15 C2                 DC W:getMessage
0147 C16E 52 C2                 DC W:delMessage
0148 C170              ;
0149 C170              ;
0150 C170              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = =
0151 C170              ;          Add a message to the message queue.
0152 C170              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = =
0153 C170              ;
0154 C170              ;  OUT:    a = error code.
0155 C170              ;
0156 C170              addMessage                              ; 
0157 C170              ;
0158 C170 20 52 C2              jsr   delMessage               First, try to delete exsisting message.
0159 C173              ;                                       Error doesn't matter.
0160 C173              ;
0161 C173              ; --- Allocate a handle and clone the given message ------------------------
0162 C173              ;
0163 C173 A5 14                 lda   <theHandle               Set handle of message tobe cloned.
0164 C175 85 04                 sta   <hand1
0165 C177 A5 16                 lda   <theHandle+2
0166 C179 85 06                 sta   <hand1+2
0167 C17B              ;
0168 C17B 48                    pha                            Space for result.
0169 C17C 48                    pha   
0170 C17D F4 00 00              pea   0                        Pass size of needed handle.
0171 C180 F4 02 00              pea   2                        (Will be resized anyway.)
0172 C183 F4 01 90              pea   MessageID                Pass ID number to use.
0173 C186 F4 08 00              pea   attrNoSpec               Anywhere but special.  (3 Apr 89)
0174 C189 48                    pha                            Address, anywhere.
0175 C18A 48                    pha   
0176 C18B A2 02 09 22           _NewHandle 
0177 C192 FA                    plx   
0178 C193 86 14                 stx   <theHandle
0179 C195 FA                    plx   
0180 C196 86 16                 stx   <theHandle+2
0181 C198 B0 7A                 bcs   exit100
0182 C19A              ;
0183 C19A 20 1A C2              jsr   cloneMessage             theHandle = hand1.
0184 C19D B0 75                 bcs   exit100
0185 C19F              ;
0186 C19F              ;
0187 C19F              ; --- Link the new message into the message queue --------------------
0188 C19F              ;
0189 C19F 20 89 C2              jsr   getFirst                 hand1 = handle of first message.
0190 C1A2              ;
0191 C1A2 D4 06                 pei   <hand1+2                 Save handle of first message.
0192 C1A4 D4 04                 pei   <hand1
0193 C1A6              ;
0194 C1A6 A5 14                 lda   <theHandle               New handle must be a real handle.
0195 C1A8 A6 16                 ldx   <theHandle+2
0196 C1AA 20 9E C2              jsr   deref
0197 C1AD              ;
0198 C1AD 68                    pla                            Current first message will be after
0199 C1AE 87 00                 sta   [<pointer]               new message.
0200 C1B0 68                    pla   
0201 C1B1 97 00                 sta   [<pointer],y
0202 C1B3              ;
0203 C1B3 C8                    iny                            Set the type field.
0204 C1B4 C8                    iny   
0205 C1B5 A5 18                 lda   <theType
0206 C1B7 97 00                 sta   [<pointer],y
0207 C1B9              ;-----------------------------------------------------------
0208 C1B9              ;
0209 C1B9              ; Kludge to fix Bug In Finder 1.0, 1.1 and 1.2
0210 C1B9              ;
0211 C1B9 C9 02 00              cmp   #2                       ; is the message the desktop pattern message?
0212 C1BC D0 45                 bne   NoKludge
0213 C1BE
0214 C1BE 48                    pha                            ; what is the handle size
0215 C1BF 48                    pha   
0216 C1C0 D4 06                 pei   <hand1+2
0217 C1C2 D4 04                 pei   <hand1
0218 C1C4 A2 02 18 22           _GetHandleSize 
0219 C1CB 68                    pla   
0220 C1CC FA                    plx   
0221 C1CD D0 34                 bne   NoKludge                 ; if its > $10000, it cannot right but need not be adjusted
0222 C1CF C9 28 00              cmp   #$28                     ; if it is >= $28 then it is OK
0223 C1D2 B0 2F                 bcs   NoKludge
0224 C1D4
0225 C1D4 F4 00 00 F4           PushLong #$28                  ; Make it $28
0226 C1DA D4 06                 pei   <hand1+2
0227 C1DC D4 04                 pei   <hand1
0228 C1DE A2 02 19 22           _SetHandleSize 
0229 C1E5
0230 C1E5 A5 04                 lda   <hand1                   ; deref the new handle
0231 C1E7 A6 06                 ldx   <hand1+2
0232 C1E9 20 9E C2              jsr   deref
0233 C1EC
0234 C1EC A0 08 00              ldy   #$08                     ; copy the lower half of the pattern into
0235 C1EF A2 18 00              ldx   #$18                     ; the upper half of the pattern
0236 C1F2 B7 00        @Loop    lda   [Pointer],y
0237 C1F4 5A                    phy   
0238 C1F5 9B                    txy   
0239 C1F6 97 00                 sta   [Pointer],y
0240 C1F8 BB                    tyx   
0241 C1F9 7A                    ply   
0242 C1FA C8                    iny   
0243 C1FB C8                    iny   
0244 C1FC E8                    inx   
0245 C1FD E8                    inx   
0246 C1FE C0 18 00              cpy   #$18
0247 C201 90 EF                 bcc   @Loop
0248 C203
0249 C203              NoKludge  
0250 C203
0251 C203              ;
0252 C203              ;
0253 C203              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = =
0254 C203              ;          Set new first handle in message gueue.
0255 C203              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = =
0256 C203              ;
0257 C203              ;   IN:    hand1 = handle of first message.
0258 C203              ;
0259 C203              setNewFirst                             ; 
0260 C203              ;
0261 C203 F4 00 00              pea   0                        System.
0262 C206 F4 02 00              pea   2                        Memory manager.
0263 C209 D4 06                 pei   <hand1+2                 New first message.
0264 C20B D4 04                 pei   <hand1
0265 C20D A2 01 0D 22           _SetWAP 
0266 C214 60           exit100  rts                            Return error flag from SetWAP.
0267 C215              ;
0268 C215              ;
0269 C215              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = =
0270 C215              ;          Get a message from the message queue.
0271 C215              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = =
0272 C215              ;
0273 C215              ;  OUT:    a = error code.
0274 C215              ;
0275 C215              getMessage                              ; 
0276 C215              ;
0277 C215 20 B2 C2              jsr   findMessage              Find the message.
0278 C218 B0 37                 bcs   exit200                  Was the message found?
0279 C21A              ;
0280 C21A              ;
0281 C21A              ;   IN:    hand1 = handle of message to clone.
0282 C21A              ;          theHandle = handle of cloned message.
0283 C21A              ;
0284 C21A              ;  OUT:    Carry set if error and A equals error code.
0285 C21A              ;
0286 C21A              cloneMessage                            ; 
0287 C21A              ;
0288 C21A 48                    pha                            Space for result.
0289 C21B 48                    pha   
0290 C21C D4 06                 pei   <hand1+2                 Pass handle of found message.
0291 C21E D4 04                 pei   <hand1
0292 C220 A2 02 18 22           _GetHandleSize                 Get the size of the message.
0293 C227 7A                    ply   
0294 C228 FA                    plx   
0295 C229 B0 26                 bcs   exit200
0296 C22B              ;
0297 C22B 84 08                 sty   <hand2                   Keep size in 'hand2'.
0298 C22D 86 0A                 stx   <hand2+2
0299 C22F              ;
0300 C22F DA                    phx                            Pass size of message.
0301 C230 5A                    phy   
0302 C231 D4 16                 pei   <theHandle+2             Pass the handle given by caller.
0303 C233 D4 14                 pei   <theHandle
0304 C235 A2 02 19 22           _SetHandleSize                 Given handle = size of message.
0305 C23C B0 13                 bcs   exit200
0306 C23E              ;
0307 C23E D4 06                 pei   <hand1+2                 Pass handle of found message, source.
0308 C240 D4 04                 pei   <hand1
0309 C242 D4 16                 pei   <theHandle+2             Pass the handle given by caller.
0310 C244 D4 14                 pei   <theHandle
0311 C246 D4 0A                 pei   <hand2+2                 Pass number of bytes to copy.
0312 C248 D4 08                 pei   <hand2
0313 C24A A2 02 2A 22           _HandtoHand 
0314 C251 60           exit200  rts   
0315 C252              ;
0316 C252              ;
0317 C252              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = =
0318 C252              ;          Delete a message from the message queue.
0319 C252              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = =
0320 C252              ;
0321 C252              ;   IN:    theType = message type to delete.
0322 C252              ;
0323 C252              ;  OUT:    Carry clear if deleted, set if not found.
0324 C252              ;          a = error code.
0325 C252              ;
0326 C252              delMessage                              ; 
0327 C252              ;
0328 C252 20 B2 C2              jsr   findMessage
0329 C255 B0 31                 bcs   exit300                  Was the message found?
0330 C257              ;
0331 C257              ;
0332 C257              ; hand1 = message to delete.
0333 C257              ; hand2 = previous message.
0334 C257              ; pointer = (hand1).
0335 C257              ;
0336 C257 D4 06                 pei   <hand1+2                 Pass dead message handle
0337 C259 D4 04                 pei   <hand1                   to _DisposeHandle.
0338 C25B              ;
0339 C25B              ;
0340 C25B A7 00                 lda   [<pointer]               Get handle of message after dead message.
0341 C25D 85 04                 sta   <hand1
0342 C25F A0 02 00              ldy   #2
0343 C262 B7 00                 lda   [<pointer],y
0344 C264 85 06                 sta   <hand1+2
0345 C266              ;
0346 C266 A5 08                 lda   <hand2                   Was there a previous message?
0347 C268 05 0A                 ora   <hand2+2
0348 C26A D0 05                 bne   relink
0349 C26C              ;
0350 C26C 20 03 C2              jsr   setNewFirst
0351 C26F 80 10                 bra   exit301
0352 C271              ;
0353 C271              ;
0354 C271 A7 08        relink   lda   [<hand2]                 Dereference preivous message handle.
0355 C273 85 00                 sta   <pointer
0356 C275 B7 08                 lda   [<hand2],y
0357 C277 85 02                 sta   <pointer+2
0358 C279              ;
0359 C279 A5 04                 lda   <hand1                   Message after dead message, is now
0360 C27B 87 00                 sta   [<pointer]               the message after the previous message.
0361 C27D A5 06                 lda   <hand1+2
0362 C27F 97 00                 sta   [<pointer],y
0363 C281              ;
0364 C281              ;
0365 C281 A2 02 10 22  exit301  _DisposeHandle                 Free dead message (handle on stack).
0366 C288              ;                                       Return error from DisposeHandle.
0367 C288 60           exit300  rts   
0368 C289              ;
0369 C289              ;
0370 C289              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = =
0371 C289              ;          Get first handle in message gueue.
0372 C289              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = =
0373 C289              ;
0374 C289              ;   IN:    None.
0375 C289              ;
0376 C289              ;  OUT:    hand1 = handle of first message.
0377 C289              ;          hand2 = zero.
0378 C289              ;          pointer = (hand1)
0379 C289              ;          BEQ if no first message.
0380 C289              ;
0381 C289              getFirst                                ; 
0382 C289              ;
0383 C289 64 08                 stz   <hand2
0384 C28B 64 0A                 stz   <hand2+2
0385 C28D              ;
0386 C28D 48                    pha                            Space for result.
0387 C28E 48                    pha   
0388 C28F F4 00 00              pea   0                        System.
0389 C292 F4 02 00              pea   2                        Memory manager's.
0390 C295 A2 01 0C 22           _GetWAP 
0391 C29C 68                    pla                            Handle of first message.
0392 C29D FA                    plx   
0393 C29E              ;
0394 C29E              ;
0395 C29E              ; = = = = = = = = = = = = = = = = = = =
0396 C29E              ;          Dereference handle.
0397 C29E              ; = = = = = = = = = = = = = = = = = = =
0398 C29E              ;
0399 C29E              ;   IN:    a = low word of handle.
0400 C29E              ;          x = high word of handle.
0401 C29E              ;
0402 C29E              ;  OUT:    hand1 = given handle.
0403 C29E              ;          pointer = (hand1).
0404 C29E              ;          y = 2.
0405 C29E              ;          BEQ if hand1 was zero.
0406 C29E              ;
0407 C29E 85 04        deref    sta   <hand1
0408 C2A0 86 06                 stx   <hand1+2
0409 C2A2              ;
0410 C2A2 A7 04                 lda   [<hand1]                 Dereference the message handle.
0411 C2A4 85 00                 sta   <pointer
0412 C2A6 A0 02 00              ldy   #2
0413 C2A9 B7 04                 lda   [<hand1],y
0414 C2AB 85 02                 sta   <pointer+2
0415 C2AD              ;
0416 C2AD A5 04                 lda   <hand1
0417 C2AF 05 06                 ora   <hand1+2
0418 C2B1 60                    rts   
0419 C2B2              ;
0420 C2B2              ;
0421 C2B2              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = =
0422 C2B2              ;          Find a message in the message gueue.
0423 C2B2              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = =
0424 C2B2              ;
0425 C2B2              ;   IN:    theType = message type to delete.
0426 C2B2              ;
0427 C2B2              ;  OUT:    Carry clear if found:
0428 C2B2              ;            hand1 = handle of message found.
0429 C2B2              ;            hand2 = handle of message before found message (zero if first).
0430 C2B2              ;            pointer = (hand1)
0431 C2B2              ;          Carry set if not found:
0432 C2B2              ;            a = error code.
0433 C2B2              ;
0434 C2B2              findMessage                             ; 
0435 C2B2              ;
0436 C2B2 20 89 C2              jsr   getFirst                 Get handle of first message.
0437 C2B5 F0 1B                 beq   exit401                  Are there any messages?
0438 C2B7              ;
0439 C2B7 B7 00        lop400   lda   [<pointer],y             (Get high word handle of next message)
0440 C2B9 AA                    tax                            (while Y is set correctly.)
0441 C2BA              ;
0442 C2BA C8                    iny                            Match type.
0443 C2BB C8                    iny   
0444 C2BC B7 00                 lda   [<pointer],y             This message's type.
0445 C2BE C5 18                 cmp   <theType                 Match?
0446 C2C0 18                    clc                            Found flag, just in case.
0447 C2C1 F0 13                 beq   exit400
0448 C2C3              ;
0449 C2C3 A5 04                 lda   <hand1                   Remember previous handle.
0450 C2C5 85 08                 sta   <hand2
0451 C2C7 A5 06                 lda   <hand1+2
0452 C2C9 85 0A                 sta   <hand2+2
0453 C2CB              ;
0454 C2CB A7 00                 lda   [<pointer]               Get handle of next message.
0455 C2CD              ;                                       X already equals high word.
0456 C2CD              ;
0457 C2CD 20 9E C2     enter400 jsr   deref
0458 C2D0 D0 E5                 bne   lop400                   Any more messages?
0459 C2D2              ;
0460 C2D2 A9 11 01     exit401  lda   #MessNotFound
0461 C2D5 38                    sec                            Message not found flag.
0462 C2D6 60           exit400  rts   
0463 C2D7
0464 C2D7                       ENDP 
0465 C2D7
0466 C2D7                       END   
